/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.messaging.types;

import com.badlogic.gdx.math.Vector2;

public class MouseChangeMessage {
    private final int screenX;
    private final int screenY;
    private final Vector2 worldPosition;
    private final MouseButtonType buttonType;

    public MouseChangeMessage(int screenX, int screenY, Vector2 worldPosition, MouseButtonType buttonType) {
        this.screenX = screenX;
        this.screenY = screenY;
        this.worldPosition = worldPosition;
        this.buttonType = buttonType;
    }

    public int getScreenX() {
        return this.screenX;
    }

    public int getScreenY() {
        return this.screenY;
    }

    public Vector2 getWorldPosition() {
        return this.worldPosition;
    }

    public MouseButtonType getButtonType() {
        return this.buttonType;
    }

    public static enum MouseButtonType {
        PRIMARY_BUTTON(0),
        CANCEL_BUTTON(1),
        MIDDLE_BUTTON(2);

        private final int inputButtonCode;

        private MouseButtonType(int inputButtonCode) {
            this.inputButtonCode = inputButtonCode;
        }

        public int getInputButtonCode() {
            return this.inputButtonCode;
        }

        public static MouseButtonType byButtonCode(int inputButtonCode) {
            for (MouseButtonType mouseButtonType : MouseButtonType.values()) {
                if (mouseButtonType.inputButtonCode != inputButtonCode) continue;
                return mouseButtonType;
            }
            return null;
        }
    }
}

